﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using Malefiz.Klassen_für_Spielbrett;

namespace Malefiz
{
    public class Figur : Spielobjekt
    {
        private Figurennummerierung nummerierung = new Figurennummerierung();

        

        /// <summary>
        /// In dieser Eigenschaft wird die Spielernummer und die Figurennummer gespeichert.
        /// </summary>
        public Figurennummerierung Nummerierung
        {
            get { return nummerierung; }
        }

        /// <summary>
        /// In dieser Eigenschaft wird die Spielernummer des Spielers gespeichert, dem diese Figur gehört.
        /// </summary>
        public int Spielernummer
        {
            get { return nummerierung.SpielerNummer; }
        }

        /// <summary>
        /// In dieser Eigenschaft wird die Figugennummer dieser Spielfigur gespeichert.
        /// </summary>
        public int Figurennummer
        {
            get { return nummerierung.FigurenNummer; }
        }

        /// <summary>
        /// Befindet sich diese Figur aktuell auf ihrem Hausfeld? Zur Initialisierung dieser Figur steht diese Eigenschaft auf true.
        /// </summary>
        public bool Im_Haus { get; set; }
        


        //Konstruktor

        /// <summary>
        /// Erstellt eine Spielfigur mit einer Spielernummer und einer Figurnummer. Es wird automatisch die Startposition 
        /// der Spielfigur festgelegt (dies ist das Feld vor dem Haus) und der Figur wird automatisch das passende Porträt in die 
        /// Eigenschaft Porträt geschrieben. Die Spielernummer und die Figurennummer können anschließend nicht mehr verändert
        /// werden.
        /// Voreinstellungen: 
        /// ImHaus = true
        /// </summary>
        /// <param name="spielernummer">Die Spielernummer dieser Figur: 
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler</param>
        /// <param name="figurennummer">Die Figurnummer dieser Figur:
        /// 0: Figur 1 ... 4: Figur 5</param>
        public Figur(int spielernummer, int figurennummer) : base()
        {
            nummerierung.SpielerNummer = spielernummer;
            nummerierung.FigurenNummer = figurennummer;
            Im_Haus = true;

            //Legt die Startposition dieser Spielfigur fest. Diese hängt davon ab, zu welchem Spieler diese Figur gehört.
            if (spielernummer == 0)     //Roter Spieler
            { X = 2; Y = 0; }
            if (spielernummer == 1)     //Grüner Spieler
            { X = 6; Y = 0; }
            if (spielernummer == 2)     //Gelber Spieler
            { X = 10; Y = 0; }
            if (spielernummer == 3)     //Blauer Spieler
            { X = 14; Y = 0; }

            //Bestimmt, welches Porträt (welche Farbe) diese Figur hat. Diese hängt davon ab, zu welchem Spieler diese Figur gehört.
            if (spielernummer == 0)             //Roter Spieler
            { Porträt = pictures.Figur_rot; }
            if (spielernummer == 1)             //Grüner Spieler
            { Porträt = pictures.Figur_grün; }
            if (spielernummer == 2)             //Gelber Spieler
            { Porträt = pictures.Figur_gelb; }
            if (spielernummer == 3)             //Blauer Spieler
            { Porträt = pictures.Figur_blau; }
        }



        /// <summary>
        /// Diese Methode soll aufgerufen werden, nachdem die Spielfigur von einer anderen Figur geschlagen wurde. 
        /// Dabei wird die Eigenschaft ImHaus auf true gesetzt und die Spielfigur wird automatisch auf ihre 
        /// Startposition gesetzt (dies ist das Feld vor dem Haus).
        /// </summary>
        public void Geschlagen()
        {
            Im_Haus = true;

            if(Spielernummer == 0)      //Roter Spieler
            { this.X = 2; this.Y = 0; }
            if(Spielernummer == 1)      //Grüner Spieler
            { this.X = 6; this.Y = 0; }
            if(Spielernummer == 2)      //Gelber Spieler
            { this.X = 10; this.Y = 0; }
            if(Spielernummer == 3)      //Blauer Spieler
            { this.X = 14; this.Y = 0; }
        }
    }
}